--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A Variable is an object that determines the type and location of the value being set by a setting. It could be a field on a table, or inside a config file, etc.
--- 
--- The Variable base class can be used for custom variables by defining the get and set fields to retrieve and save the value to a specified location. Variable subclasses exist for default behavior.
--- @class mwseMCMVariable
--- @field class string The type of the variable.
--- @field componentType "Variable" The type of this component.
--- @field converter fun(newValue): unknown This function is called when the value of the variable is changed. The function can modify the new value before it is stored.
--- @field id string The unique identifier for the variable.
--- @field inGameOnly boolean If true, the setting containing this variable will be disabled while the game is on main menu.
--- @field restartRequired boolean If true, updating the setting containing this variable will notify the player to restart the game.
--- @field restartRequiredMessage string The default text is a localized version of: "The game must be restarted before this change will come into effect.".
--- @field value unknown The value stored in the variable.
mwseMCMVariable = {}

--- Returns the value stored in the variable.
--- @return unknown value No description yet available.
function mwseMCMVariable:get() end

--- Creates a new variable of this type.
--- @param variable? string|mwseMCMVariable.new.variable This table accepts the following values:
--- 
--- `id?`: string — *Optional*. The unique identifier for the variable.
--- 
--- `inGameOnly?`: boolean — *Default*: `false`. If true, the setting containing this variable will be disabled if the game is on main menu.
--- 
--- `numbersOnly?`: boolean — *Default*: `false`. If true, only numbers will be allowed for this variable in TextFields.
--- 
--- `restartRequired?`: boolean — *Default*: `false`. If true, updating the setting containing this variable will notify the player to restart the game.
--- 
--- `restartRequiredMessage?`: string — *Optional*.  The default text is a localized version of: "The game must be restarted before this change will come into effect.".
--- 
--- `converter?`: fun(newValue): unknown — *Optional*. This function is called when the value of the variable is changed. The function can modify the new value before it is saved.
--- @return mwseMCMConfigVariable|mwseMCMCustomVariable|mwseMCMGlobal|mwseMCMGlobalBoolean|mwseMCMPlayerData|mwseMCMTableVariable|mwseMCMVariable variable No description yet available.
function mwseMCMVariable:new(variable) end

---Table parameter definitions for `mwseMCMVariable.new`.
--- @class mwseMCMVariable.new.variable
--- @field id? string *Optional*. The unique identifier for the variable.
--- @field inGameOnly? boolean *Default*: `false`. If true, the setting containing this variable will be disabled if the game is on main menu.
--- @field numbersOnly? boolean *Default*: `false`. If true, only numbers will be allowed for this variable in TextFields.
--- @field restartRequired? boolean *Default*: `false`. If true, updating the setting containing this variable will notify the player to restart the game.
--- @field restartRequiredMessage? string *Optional*.  The default text is a localized version of: "The game must be restarted before this change will come into effect.".
--- @field converter? fun(newValue): unknown *Optional*. This function is called when the value of the variable is changed. The function can modify the new value before it is saved.

--- Changes the value stored in the variable. Calls the `converter` function with the new value before saving.
--- @param newValue unknown No description yet available.
function mwseMCMVariable:set(newValue) end

